/**
 * File: Stanford.java
 * -------------------
 * The program provides an example of using Student objects
 */

import acm.program.*;

public class Stanford extends ConsoleProgram {
	/* Constants */
	private static final int CS106A_UNITS = 5;
	
	public void run() {
		/* Stanford - the home of the large serif fonts! */
		setFont("DejaVuSerif-BOLD-24");
				
		Student keith = new Student("Keith Schwarz", 5000137);
		keith.setUnits(137);
		printUnits(keith);

		Student jeremy = new Student("Jeremy Keeshin", 5000138);
		jeremy.setUnits(179);
		printUnits(jeremy);
		
		Frosh dina = new Frosh("Dina", 137, "Donner");
		dina.setUnits(2389623);
		printUnits(dina);
	}
	
	/**
	 * Prints the name and number of units that student stud has,
	 * as well as whether the student can graduate
	 * @param stud The student who we will print information for
	 */
	private void printUnits(Student stud) {
		println(stud + " has " + stud.getUnits() + " units");
	}
}
